﻿using System;
using NCMS.Utils;
using UnityEngine;
using UnityEngine.Events;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text.RegularExpressions;
using System.Reflection;
using ReflectionUtility;

namespace Diplomacy_Army
{
    class DiplomacyPowerWindow
    {
        public static string name = "DiplomacyControlWindow";
        public static PowerButton powerButton;

        private static ScrollWindow window;
        private static GameObject content;
        private static GodPower power;
        private static int index = 0;

        // Initializing Tiles Window
        internal static PowerButtonSelector pbsInstance;
        public static void init()
        {
            // Creating new window
            window = Windows.CreateNewWindow(name, "Select Tile");

            // Activating Scroll View object
            var scrollView = GameObject.Find($"/Canvas Container Main/Canvas - Windows/windows/{window.name}/Background/Scroll View");
            scrollView.gameObject.SetActive(true);


            // Fixing size to fit
            var viewport = GameObject.Find($"/Canvas Container Main/Canvas - Windows/windows/{window.name}/Background/Scroll View/Viewport");
            var viewportRect = viewport.GetComponent<RectTransform>();
            viewportRect.sizeDelta = new Vector2(0, 17);

            // Getting Content object
            content = GameObject.Find($"/Canvas Container Main/Canvas - Windows/windows/{window.name}/Background/Scroll View/Viewport/Content");

            // Getting power button selector using reflections with ReflectionUtility
            pbsInstance = Reflection.GetField(typeof(PowerButtonSelector), null, "instance") as PowerButtonSelector;

            initDiplomacyControl();
        }

        private static void initDiplomacyControl()
		{
			createTileButton(index++, content.transform, "互不侵犯", "historyLog", "双方签订互不侵犯条约", new UnityAction(tryToHideWindow));
			createTileButton(index++, content.transform, "共同防御", "historyLog", "双方签订共同防御条约", new UnityAction(tryToHideWindow2));
			createTileButton(index++, content.transform, "军事通行", "historyLog", "双方签订军事通行条约", new UnityAction(tryToHideWindow3));
			index += 2;
			createTileButton(index++, content.transform, "取消条约（互不侵犯）", "historyLog", "双方取消互不侵犯条约", new UnityAction(tryToHideWindow6));
			createTileButton(index++, content.transform, "取消条约（共同防御）", "historyLog", "双方取消共同防御条约", new UnityAction(tryToHideWindow7));
			createTileButton(index++, content.transform, "取消条约（军事通行）", "historyLog", "双方取消军事通行条约", new UnityAction(tryToHideWindow8));

		}


        private static void createTileButton(int index, Transform pParent, string powerID, string pSprite, string pDescription, UnityAction pCall = null)
        {
            GodPower godPower = new GodPower();
            godPower.id = powerID;
            godPower.name = powerID;
            godPower.unselectWhenWindow = true;
            AssetManager.powers.add(godPower);
            NewFunction.CreateNewButtonOnWindow(NewFunction.getPositionByIndex(index), pParent, pSprite, godPower, pDescription, pCall, PowerButtonType.Active);
        }

		public static bool tryToSingAllianceTreaty(WorldTile pTile, string pPower)
		{
			if (pTile.zone.city == null)
			{
				return false;
			}
			var kingdom = Reflection.GetField(pTile.zone.city.GetType(), pTile.zone.city, "kingdom") as Kingdom;
			if (MoreGodPower.selected_kingdom == null)
			{
				MoreGodPower.selected_kingdom = kingdom;
				NewFunction.LogNewMessage(kingdom, "国家", "想要与某个国家签订互不侵犯条约......");
			}
			else
			{
				if (kingdom == MoreGodPower.selected_kingdom)
				{
					return false;
				}
				if (MoreGodPower.selected_kingdom.civs_enemies.ContainsKey(kingdom))
				{
					NewFunction.LogNewMessage(MoreGodPower.selected_kingdom, kingdom, "", "与", "正处于交战状态");
					MoreGodPower.selected_kingdom = null;
					return false;
				}
				NewFunction.signNewTreaty(MoreGodPower.AllianceKingdoms, MoreGodPower.selected_kingdom, kingdom, "互不侵犯", 30, TreatyType.Alliance, true);
				MoreGodPower.selected_kingdom = null;
			}
			return true;
		}

		public static bool tryToSingDefenceTreaty(WorldTile pTile, string pPower)
		{
			if (pTile.zone.city == null)
			{
				return false;
			}
			var kingdom = Reflection.GetField(pTile.zone.city.GetType(), pTile.zone.city, "kingdom") as Kingdom;
			if (MoreGodPower.selected_kingdom == null)
			{
				MoreGodPower.selected_kingdom = kingdom;
				NewFunction.LogNewMessage(kingdom, "国家", "想要与某个国家签订共同防御条约......");
			}
			else
			{
				if (kingdom == MoreGodPower.selected_kingdom)
				{
					return false;
				}
				if (MoreGodPower.selected_kingdom.civs_enemies.ContainsKey(kingdom))
				{
					NewFunction.LogNewMessage(MoreGodPower.selected_kingdom, kingdom, "", "与", "正处于交战状态");
					MoreGodPower.selected_kingdom = null;
					return false;
				}
				NewFunction.signNewTreaty(MoreGodPower.DefenceKingdoms, MoreGodPower.selected_kingdom, kingdom, "共同防御", 30, TreatyType.Defence);
				NewFunction.signNewTreaty(MoreGodPower.AllianceKingdoms, MoreGodPower.selected_kingdom, kingdom, "互不侵犯", 30, TreatyType.Alliance, true, false);
			}
			return true;
		}

		public static bool tryToSingArmyTreaty(WorldTile pTile, string pPower)
		{
			if (pTile.zone.city == null)
			{
				return false;
			}
			var kingdom = Reflection.GetField(pTile.zone.city.GetType(), pTile.zone.city, "kingdom") as Kingdom;
			if (MoreGodPower.selected_kingdom == null)
			{
				MoreGodPower.selected_kingdom = kingdom;
				NewFunction.LogNewMessage(kingdom, "国家", "想要与某个国家签订军事通行条约......");
			}
			else
			{
				if (kingdom == MoreGodPower.selected_kingdom)
				{
					return false;
				}
				if (MoreGodPower.selected_kingdom.civs_enemies.ContainsKey(kingdom))
				{
					NewFunction.LogNewMessage(MoreGodPower.selected_kingdom, kingdom, "", "与", "正处于交战状态");
					MoreGodPower.selected_kingdom = null;
					return false;
				}
				NewFunction.signNewTreaty(MoreGodPower.ArmyKingdoms, MoreGodPower.selected_kingdom, kingdom, "军事通行", 30, TreatyType.Army);
				NewFunction.signNewTreaty(MoreGodPower.AllianceKingdoms, MoreGodPower.selected_kingdom, kingdom, "互不侵犯", 30, TreatyType.Alliance, true, false);
				MoreGodPower.selected_kingdom = null;
			}
			return true;
		}

		public static bool tryToDesignAllianceTreaty(WorldTile pTile, string pPower)
		{
			if (pTile.zone.city == null)
			{
				return false;
			}
			var kingdom = Reflection.GetField(pTile.zone.city.GetType(), pTile.zone.city, "kingdom") as Kingdom;
			if (MoreGodPower.selected_kingdom == null)
			{
				MoreGodPower.selected_kingdom = kingdom;
				NewFunction.LogNewMessage(kingdom, "国家", "想要与某个国家解除互不侵犯条约......");
			}
			else
			{
				if (kingdom == MoreGodPower.selected_kingdom)
				{
					return false;
				}
				if (!(MoreGodPower.AllianceKingdoms.ContainsKey(MoreGodPower.selected_kingdom) && MoreGodPower.AllianceKingdoms[MoreGodPower.selected_kingdom].ContainsKey(kingdom)))
				{
					NewFunction.LogNewMessage(MoreGodPower.selected_kingdom, kingdom, "", "与", "没有签订互不侵犯条约");
					MoreGodPower.selected_kingdom = null;
					return false;
				}
				NewFunction.designTreaty(MoreGodPower.AllianceKingdoms, MoreGodPower.selected_kingdom, kingdom, "互不侵犯", true);
				NewFunction.designTreaty(MoreGodPower.DefenceKingdoms, MoreGodPower.selected_kingdom, kingdom, "共同防御", false);
				NewFunction.designTreaty(MoreGodPower.ArmyKingdoms, MoreGodPower.selected_kingdom, kingdom, "军事通行", false);
				MoreGodPower.selected_kingdom = null;
			}
			return true;
		}

		public static bool tryToDesignDefenceTreaty(WorldTile pTile, string pPower)
		{
			if (pTile.zone.city == null)
			{
				return false;
			}
			var kingdom = Reflection.GetField(pTile.zone.city.GetType(), pTile.zone.city, "kingdom") as Kingdom;
			if (MoreGodPower.selected_kingdom == null)
			{
				MoreGodPower.selected_kingdom = kingdom;
				NewFunction.LogNewMessage(kingdom, "国家", "想要与某个国家解除共同防御条约......");
			}
			else
			{
				if (kingdom == MoreGodPower.selected_kingdom)
				{
					return false;
				}
				if (!(MoreGodPower.DefenceKingdoms.ContainsKey(MoreGodPower.selected_kingdom) && MoreGodPower.DefenceKingdoms[MoreGodPower.selected_kingdom].ContainsKey(kingdom)))
				{
					NewFunction.LogNewMessage(MoreGodPower.selected_kingdom, kingdom, "", "与", "没有签订共同防御条约");
					MoreGodPower.selected_kingdom = null;
					return false;
				}
				NewFunction.designTreaty(MoreGodPower.DefenceKingdoms, MoreGodPower.selected_kingdom, kingdom, "共同防御", false);
				MoreGodPower.selected_kingdom = null;
			}
			return true;
		}

		public static bool tryToDesignArmyTreaty(WorldTile pTile, string pPower)
		{
			if (pTile.zone.city == null)
			{
				return false;
			}
			var kingdom = Reflection.GetField(pTile.zone.city.GetType(), pTile.zone.city, "kingdom") as Kingdom;
			if (MoreGodPower.selected_kingdom == null)
			{
				MoreGodPower.selected_kingdom = kingdom;
				NewFunction.LogNewMessage(kingdom, "国家", "想要与某个国家解除军事通行条约......");
			}
			else
			{
				if (kingdom == MoreGodPower.selected_kingdom)
				{
					return false;
				}
				if (!(MoreGodPower.ArmyKingdoms.ContainsKey(MoreGodPower.selected_kingdom) && MoreGodPower.ArmyKingdoms[MoreGodPower.selected_kingdom].ContainsKey(kingdom)))
				{
					NewFunction.LogNewMessage(MoreGodPower.selected_kingdom, kingdom, "", "与", "没有签订军事通行条约");
					MoreGodPower.selected_kingdom = null;
					return false;
				}
				NewFunction.designTreaty(MoreGodPower.ArmyKingdoms, MoreGodPower.selected_kingdom, kingdom, "军事通行", false);
				MoreGodPower.selected_kingdom = null;
			}
			return true;
		}

		public static void tryToHideWindow()
		{
			power = Reflection.GetField(powerButton.GetType(), powerButton, "godPower") as GodPower;
			power.click_action = null;
			power.click_action = (PowerActionWithID)Delegate.Combine(power.click_action, new PowerActionWithID(tryToSingAllianceTreaty));
			ScrollWindow.get(name).clickHide();
			pbsInstance.clickPowerButton(powerButton);
		}

		public static void tryToHideWindow2()
        {
            power = Reflection.GetField(powerButton.GetType(), powerButton, "godPower") as GodPower;
			power.click_action = null;
			power.click_action = (PowerActionWithID)Delegate.Combine(power.click_action, new PowerActionWithID(tryToSingDefenceTreaty));
            ScrollWindow.get(name).clickHide();
            pbsInstance.clickPowerButton(powerButton);
        }
        
		public static void tryToHideWindow3()
		{
			power = Reflection.GetField(powerButton.GetType(), powerButton, "godPower") as GodPower;
			power.click_action = null;
			power.click_action = (PowerActionWithID)Delegate.Combine(power.click_action, new PowerActionWithID(tryToSingArmyTreaty));
			ScrollWindow.get(name).clickHide();
			pbsInstance.clickPowerButton(powerButton);
		}

		public static void tryToHideWindow6()
		{
			power = Reflection.GetField(powerButton.GetType(), powerButton, "godPower") as GodPower;
			power.click_action = null;
			power.click_action = (PowerActionWithID)Delegate.Combine(power.click_action, new PowerActionWithID(tryToDesignAllianceTreaty));
			ScrollWindow.get(name).clickHide();
			pbsInstance.clickPowerButton(powerButton);
		}

		public static void tryToHideWindow7()
		{
			power = Reflection.GetField(powerButton.GetType(), powerButton, "godPower") as GodPower;
			power.click_action = null;
			power.click_action = (PowerActionWithID)Delegate.Combine(power.click_action, new PowerActionWithID(tryToDesignDefenceTreaty));
			ScrollWindow.get(name).clickHide();
			pbsInstance.clickPowerButton(powerButton);
		}

		public static void tryToHideWindow8()
		{
			power = Reflection.GetField(powerButton.GetType(), powerButton, "godPower") as GodPower;
			power.click_action = null;
			power.click_action = (PowerActionWithID)Delegate.Combine(power.click_action, new PowerActionWithID(tryToDesignArmyTreaty));
			ScrollWindow.get(name).clickHide();
			pbsInstance.clickPowerButton(powerButton);
		}
	}
}
